<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMobileAppBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mobile_app_briefs', function (Blueprint $table) {
            $table->id();
            $table->string('encoded_id')->nullable()->unique();
            $table->unsignedBigInteger('brief_link_id')->nullable()->index();
            $table->unsignedBigInteger('customer_id')->nullable()->index();

            $table->foreign('brief_link_id')->references('id')->on('brief_links')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->text('device')->nullable();
            $table->text('location')->nullable();
            $table->string('email', 255);
            $table->string('name', 255);
            $table->string('phone', 40)->nullable();
            $table->string('business_name', 400);
            $table->string('business_address', 400);
            $table->string('business_phone', 40)->nullable();
            $table->string('business_email', 255)->nullable();
            $table->string('business_operations', 400)->nullable();
            $table->string('website_link', 400)->nullable();
            $table->string('website_hosting', 400)->nullable();
            $table->string('website_domain', 255)->nullable();
            $table->string('app_purpose')->nullable();
            $table->string('app_tagline')->nullable();
            $table->string('app_look')->nullable();
            $table->string('app_design', 400)->nullable();
            $table->string('app_specification', 400)->nullable();
            $table->string('app_pages_section', 400)->nullable();
            $table->string('app_reference', 400)->nullable();
            $table->string('app_users', 400)->nullable();
            $table->string('app_font_style', 400)->nullable();
            $table->string('app_colors', 400)->nullable();
            $table->string('is_cms', 10)->nullable();
            $table->string('is_push_notification', 10)->nullable();
            $table->string('is_app_Logo', 10)->nullable();
            $table->string('is_logo_redesign', 10)->nullable();
            $table->string('is_third_party_api', 400)->nullable();
            $table->string('content_restriction', 400)->nullable();
            $table->string('users_accomplishment', 400)->nullable();
            $table->string('publish_assistance', 400)->nullable();
            $table->string('comments', 400)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mobile_app_briefs');
    }
}
