<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsLengthAndDeviceLocationColumnToVideoBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('video_briefs', function (Blueprint $table) {
            $table->text('device')->nullable()->after('customer_id');
            $table->text('location')->nullable()->after('device');
            
            $table->string('project_name', 400)->nullable()->change();
            $table->string('website', 400)->nullable()->change();
            $table->string('social_media', 400)->nullable()->change();
            $table->string('business_description', 400)->nullable()->change();
            $table->string('business_services', 400)->nullable()->change();
            $table->string('audience', 400)->nullable()->change();
            $table->string('competitor', 400)->nullable()->change();
            $table->string('u_s_p', 400)->nullable()->change();
            $table->string('video_purpose', 400)->nullable()->change();
            $table->string('video_duration', 400)->nullable()->change();
            $table->string('reference', 400)->nullable()->change();
            $table->string('style', 400)->nullable()->change();
            $table->string('color', 400)->nullable()->change();
            $table->string('voice', 400)->nullable()->change();
            $table->string('artist_accent', 400)->nullable()->change();
            $table->string('animation_style', 400)->nullable()->change();
            $table->string('reference_video', 400)->nullable()->change();
            $table->softDeletes(); 

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('video_briefs', function (Blueprint $table) {
            $table->dropColumn(['device', 'location']);
            $table->string('project_name', 255)->change();
            $table->string('website', 255)->change();
            $table->string('social_media', 255)->change();
            $table->string('business_description', 255)->change();
            $table->string('business_services', 255)->change();
            $table->string('audience', 255)->change();
            $table->string('competitor', 255)->change();
            $table->string('u_s_p', 255)->change();
            $table->string('video_purpose', 255)->change();
            $table->string('video_duration', 255)->change();
            $table->string('reference', 255)->change();
            $table->string('style', 255)->change();
            $table->string('color', 255)->change();
            $table->string('voice', 255)->change();
            $table->string('artist_accent', 255)->change();
            $table->string('animation_style', 255)->change();
            $table->string('reference_video', 255)->change();
            $table->dropSoftDeletes(); 
        });
    }
}
