<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBriefLinkHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('brief_link_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brief_link_id')->nullable()->index();
            $table->foreign('brief_link_id')->references('id')->on('brief_links')->onDelete('cascade')->onUpdate('cascade');
            $table->string('activity')->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->string('device')->nullable();
            $table->string('device_type')->nullable();
            $table->string('platform')->nullable();
            $table->string('country')->nullable();
            $table->string('browser')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('brief_link_histories');
    }
}
