<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateCoulmnsLengthOnWebbriefs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('web_briefs', function (Blueprint $table) {
            $table->string('phone', 40)->nullable()->change();
            $table->string('business_name', 400)->change();
            $table->string('business_address', 400)->nullable()->change();
            $table->string('business_phone', 40)->nullable()->change();
            $table->string('business_email', 400)->nullable()->change();
            $table->string('social_media_handles', 400)->nullable()->change();
            $table->string('website', 400)->nullable()->change();
            $table->string('web_hosting', 400)->nullable()->change();
            $table->string('current_domain_address', 400)->nullable()->change();
            $table->text('organization_operations')->change();
            $table->string('website1_url', 400)->nullable()->change();
            $table->string('website2_url', 400)->nullable()->change();
            $table->string('website3_url', 400)->nullable()->change();
            $table->string('slogan', 400)->nullable()->change();
            $table->string('website_fonts', 400)->nullable()->change();
            $table->string('website_colors', 400)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('web_briefs', function($table) {
            $table->string('phone', 20)->nullable()->change();
            $table->string('business_name', 255)->change();
            $table->string('business_address', 255)->nullable()->change();
            $table->string('business_phone', 20)->nullable()->change();
            $table->string('business_email', 255)->nullable()->change();
            $table->string('social_media_handles', 255)->nullable()->change();
            $table->string('website', 255)->nullable()->change();
            $table->string('web_hosting', 255)->nullable()->change();
            $table->string('current_domain_address', 255)->nullable()->change();
            $table->longText('organization_operations')->change();
            $table->string('website1_url', 255)->nullable()->change();
            $table->string('website2_url', 255)->nullable()->change();
            $table->string('website3_url', 255)->nullable()->change();
            $table->string('slogan', 255)->nullable()->change();
            $table->string('website_fonts', 255)->nullable()->change();
            $table->string('website_colors', 255)->nullable()->change();
        });
    }
}
