<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateColumnsToBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('briefs', function (Blueprint $table) {
            $table->string('logo_font', 400)->nullable()->change();
            $table->string('logo_budget', 255)->nullable()->change();
            $table->string('contact_time', 400)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('briefs', function (Blueprint $table) {
            $table->string('logo_font', 100)->nullable()->change();
            $table->string('logo_budget', 50)->nullable()->change();
            $table->string('contact_time', 50)->nullable()->change();
        });
    }
}
