<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateBriefsTableColumnsLength extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('briefs', function ($table) {
            $table->string('email', 255)->change();
            $table->string('name', 255)->change();
            $table->string('designation', 100)->nullable()->change();
            $table->string('phone', 20)->nullable()->change();
            $table->string('business_name', 400)->change();
            $table->string('slogan', 400)->nullable()->change();
            $table->string('industry', 100)->nullable()->change();
            $table->string('website', 255)->nullable()->change();
            $table->string('competitor', 255)->nullable()->change();
            $table->string('logo_color', 400)->nullable()->change();
            $table->string('logo_avoid_color', 400)->nullable()->change();
            $table->string('logo_font', 255)->nullable()->change();
            $table->string('logo_look', 400)->nullable()->change();
            $table->string('logo_budget', 100)->nullable()->change();
            $table->string('contact_time', 100)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('briefs', function ($table) {
            $table->string('email', 255)->change();
            $table->string('name', 255)->change();
            $table->string('designation', 100)->nullable()->change();
            $table->string('phone', 20)->nullable()->change();
            $table->string('business_name', 255)->change();
            $table->string('slogan', 255)->nullable()->change();
            $table->string('industry', 100)->nullable()->change();
            $table->string('website', 255)->nullable()->change();
            $table->string('competitor', 255)->nullable()->change();
            $table->string('logo_color', 50)->nullable()->change();
            $table->string('logo_avoid_color', 50)->nullable()->change();
            $table->string('logo_font', 100)->nullable()->change();
            $table->string('logo_look', 100)->nullable()->change();
            $table->string('logo_budget', 50)->nullable()->change();
            $table->string('contact_time', 50)->nullable()->change();
        });
    }
}
