<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWebBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('web_briefs', function (Blueprint $table) {
            $table->id();
            $table->string('encoded_id')->nullable()->unique();
            $table->string('email', 255);
            $table->string('name', 255);
            $table->string('phone', 20)->nullable();
            $table->string('business_name', 255);
            $table->string('business_address', 255)->nullable();
            $table->string('business_phone', 20)->nullable();
            $table->string('business_email', 255)->nullable();
            $table->string('social_media_handles', 255)->nullable();
            $table->string('website', 255)->nullable();
            $table->string('web_hosting', 255)->nullable();
            $table->string('current_domain_address', 255)->nullable();
            $table->longText('organization_operations');
            $table->text('website_purpose');
            $table->text('portray');
            $table->text('audience')->nullable();
            $table->text('pages')->nullable();
            $table->text('competitors')->nullable();
            $table->string('website1_url', 255)->nullable();
            $table->text('website1_comments')->nullable();
            $table->string('website2_url', 255)->nullable();
            $table->text('website2_comments')->nullable();
            $table->string('website3_url', 255)->nullable();
            $table->text('website3_comments')->nullable();
            $table->text('website_features')->nullable();
            $table->text('maintenance_team')->nullable();
            $table->text('website_content');
            $table->string('slogan', 255)->nullable();
            $table->text('have_logo');
            $table->text('redesign_logo')->nullable();
            $table->string('website_fonts', 255)->nullable();
            $table->string('website_colors', 255)->nullable();
            $table->text('anything_else')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('web_briefs');
    }
}
