<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentLinksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_links', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('customer_id')->unsigned()->index()->nullable();
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->string('token')->nullable()->unique();
            $table->bigInteger('valid_till')->unsigned();
            $table->string('item_name')->nullable();
            $table->float('price')->unsigned()->nullable();
            $table->enum('discount_type', ['percentage', 'flat'])->nullable();
            $table->float('discount')->nullable();
            $table->float('original_price')->nullable();
            $table->text('item_description')->nullable();
            $table->text('metadata')->nullable();

            $table->unsignedBigInteger('currency')->nullable();
            $table->foreign('currency')->references('id')->on('country_currencies')->onDelete('cascade')->onUpdate('cascade');

            $table->bigInteger('coupon_id')->unsigned()->index()->nullable();
            $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('cascade')->onUpdate('cascade');

            $table->enum('sale_type', ['fresh_sales', 'upsell'])->default('fresh_sales');

            $table->unsignedBigInteger('payment_gateway')->index();
            $table->foreign('payment_gateway')->references('id')->on('payment_gateways')->onUpdate('cascade');
            $table->unsignedBigInteger('team')->index()->nullable();
            $table->foreign('team')->references('id')->on('teams')->onDelete('cascade')->onUpdate('cascade');

            $table->enum('payment_type', ['straight', 'recurring'])->default('straight');
            $table->enum('payment_cycle', ['weekly', 'monthly', 'quarterly', 'biannually', 'annually'])->nullable();
            $table->float('remaining_amount')->nullable();
            $table->float('balance')->nullable();
            $table->text('comment')->nullable();

            $table->boolean('show_coupon')->default(true)->when(function ($table) {
                return $table->discount > 0;
            });

            $table->bigInteger('created_by')->unsigned()->index()->nullable();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('updated_by')->unsigned()->index()->nullable();
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->unsignedTinyInteger('status')->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_links');
    }
}
