<?php

namespace App\Services;

use App\Repositories\WebBrief\WebBriefRepository;

use Exception;
use Illuminate\Http\Request;

class WebBriefService
{

    private $webbriefRepository, $streakService;

    public function __construct(WebBriefRepository $webbriefRepository, StreakService $streakService)
    {
        $this->webbriefRepository = $webbriefRepository;
        $this->streakService = $streakService;
    }

    public function create($briefDetails)
    {
        try {
            $brief = $this->webbriefRepository->createBrief($briefDetails);

            $this->streakService->createBox([
                "name" => $data['name'] ?? '',
                "company_name" => $brief['business_name'] ?? '',
                "phone_number" => $brief['phone_number'] ?? '',
                "industry" => '',
                "brief_url" => !empty($brief['encoded_id']) ? route('frontend.web.brief.view', $brief['encoded_id']) : '',
                "email" => $brief['email'] ?? '',
            ]);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function list(Request $request) {
        try {
            $briefs = $this->webbriefRepository->getAllBriefs($request);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getBrief($id)
    {
        try {
            $brief = $this->webbriefRepository->getBrief($id);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetchByEncodedID($briefID, $authenticated=false)
    {
        try {
            $brief = $this->webbriefRepository->getByEncodedID($briefID, $authenticated);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
}