<?php

namespace App\Services;

use App\Repositories\Role\RoleInterface;
use Exception;

class RoleService
{
    private $roleRepository;

    public function __construct(RoleInterface $roleRepository)
    {
        $this->roleRepository = $roleRepository;
    }

    public function create($teamDetails)
    {
        try {
            $team = $this->roleRepository->addOrUpdate($teamDetails);
            return $team;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getRoleById($roleID)
    {
        try {
            $role = $this->roleRepository->role($roleID);
            return $role;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function updateRole($roleDetails)
    {
        try {
            $role = $this->roleRepository->addOrUpdate($roleDetails);
            return $role;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function archiveRole($roleID)
    {
        try {
            $role = $this->roleRepository->softDeleteRole($roleID);
            return $role;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function deleteRole($roleID)
    {
        try {
            $role = $this->roleRepository->forceDeleteRole($roleID);
            return $role;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function restoreRole($roleID)
    {
        try {
            $role = $this->roleRepository->restoreRole($roleID);
            return $role;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function updateRoleMetadata($roleDetails)
    {
        try {
            $role = $this->roleRepository->updateRoleMetadata($roleDetails);
            return $role;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
}
