<?php

namespace App\Services\Payment\Stripe;

use Stripe\StripeClient;

class Stripe
{
    protected $public_key, $secret_key, $statement_descriptor, $environment;
    protected $stripe;

    public function __construct()
    {
        $this->paymentSetting(); 
    }

    public function paymentSetting()
    {
        $payment_gateway = Session()->get('payment_gateway');

        $this->public_key = $payment_gateway['public_key'];
        $this->secret_key = $payment_gateway['secret_key'];
        $this->statement_descriptor = $payment_gateway['statement_descriptor'];
        $this->environment = $payment_gateway['environment'];

        $this->stripe = new StripeClient($this->secret_key);
    }
}
