<?php

namespace App\Services\Payment\Stripe;

use App\Services\StripeErrorHandler;
use Exception;

class Refund extends Stripe
{
  public function all($start= "", $end="",$limit = 0)
  {
    try {
      $this->paymentSetting();
      $options = [];
      
      if($start != "" ) {
        $options['start'] = $start;
      }

      if($end != "" ) {
        $options['end'] = $end;
      }

      if($limit > 0 ) {
        $options['limit'] = $limit;
      }
      
      $refunds = $this->stripe->refunds->all($options);

      return $refunds;
    } catch (Exception $e) {
      StripeErrorHandler::handle($e);
    }
  }
}
