<?php

namespace App\Services\Payment\Stripe;

use App\Services\StripeErrorHandler;
use Exception;

class PaymentMethod extends Stripe
{
    public function create($item)
    {
        try {
            $this->paymentSetting();

            $paymentMethod = $this->stripe->paymentMethods->create([
                'type' => 'card',
                'card' => [
                    'number' => $item->cardNo,
                    'exp_month' => $item->cardExp_month,
                    'exp_year' => $item->cardExp_year,
                    'cvc' => $item->card_cvc,
                ],
                'billing_details' => [
                    'address' => [
                        'city' => $item->city,
                        'country' => $item->currency_country->aplha_code2,
                        'line1' => $item->address,
                        'postal_code' => $item->zipcode,
                        'state' => $item->state
                    ],
                    'email' => $item->email,
                    'name' => $item->first_name . ' ' . $item->last_name,
                    'phone' => $item->phone,
                ]
            ]);

            return $paymentMethod;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }

    public function get($paymentMethodID)
    {
        try {
            $this->paymentSetting();
            $intent = $this->stripe->paymentMethods->retrieve($paymentMethodID);

            return $intent;
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }

    public function attach($paymentMethodID, $customerID) {
        try {
            $this->paymentSetting();
            $payment_method = $this->stripe->paymentMethods->retrieve($paymentMethodID);
            // Attaching Customer with Payment Method
            $payment_method->attach([
                ['customer' => $customerID]
            ]);
        } catch (Exception $e) {
            StripeErrorHandler::handle($e);
        }
    }
}
