<?php 
namespace App\Services\Export;

use App\Models\User;
use App\Repositories\Export\ExportRepository;
use Exception;

class StaffExport {
  protected $exportRepository;

  public function __construct(ExportRepository $exportRepository) {
    $this->exportRepository = $exportRepository;
  }

  public function columns() {
    $exportColumns = array(
      'key' => 'staff',
      'text' => 'Staff Details',
      'columns' => array(
        array('key' => 'id', 'text' => 'id', 'default' => true),
        array('key' => 'first_name', 'text' => 'first_name', 'default' => true),
        array('key' => 'last_name', 'text' => 'last_name', 'default' => true),
        array('key' => 'email', 'text' => 'email', 'default' => true),
        array('key' => 'phone', 'text' => 'phone', 'default' => true),
        array('key' => 'address', 'text' => 'address', 'default' => true),
        array('key' => 'company', 'text' => 'company_name', 'default' => true),
        array('key' => 'city', 'text' => 'city', 'default' => true),
        array('key' => 'state', 'text' => 'state', 'default' => true),
        array('key' => 'zipcode', 'text' => 'zip', 'default' => true),
        array('key' => 'country', 'text' => 'country', 'default' => true),
        array('key' => 'created_at', 'text' => 'datetime', 'default' => true),
      ),
    );

    $this->exportRepository->headings($exportColumns);

    return $exportColumns; 
  }

  public function export($data) {
    try {
      $customersData = User::whereDoesntHave('roles', function ($query) {
        $query->where('name', 'Customer');
      });
  
      if(!empty($data['dateRange']) && !empty($data['dateRange']['start']) && !empty($data['dateRange']['end'])) {
        $customersData = $customersData->whereBetween('created_at', [$data['dateRange']['start'], $data['dateRange']['end']]);
      }
      $customers = $customersData->get();
  
      $customersExport = $this->exportRepository->process($customers, $data);
  
      $customersExport = $this->exportRepository->export();
  
      return $customersExport;
    } catch(Exception $e) {
      throw new $e;
    }
  }
}