<?php

namespace App\Services;

use App\Models\BriefLog;
use App\Repositories\BriefLog\BriefLogRepository;
use Exception;

class BriefLogService
{
    private $briefLog, $briefLogRepository;

    public function __construct(BriefLog $briefLog, BriefLogRepository $briefLogRepository)
    {
        $this->briefLog = $briefLog;
        $this->briefLogRepository = $briefLogRepository;
    }

    public function log($data, $routeTo = "")
    {
        try {

            $data['brief_type'] = $this->quoteClasses($data['brief_type'])['class'];

            $briefLog = $this->briefLogRepository->log($data);
            $briefLog = $briefLog->refresh();

            if ($routeTo) {
                $briefLog->route = $routeTo;
            }

            return $briefLog;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    function update($id, $data, $routeTo = "")
    {
        $data['brief_type'] = $this->quoteClasses($data['brief_type'])['class'];

        $log = $this->briefLogRepository->updateLog($id, $data);
        $log = $log->refresh();

        if ($routeTo) {
            $log->route = $routeTo;
        }

        return $log;
    }


    function pinLog($pinLogID, $briefID, $type, $pin = '', $routeTo = "")
    {
        $logClass = $this->quoteClasses($type);
        $log = $this->briefLogRepository->pinLog($pinLogID, $briefID, $pin);
        $log = $log->refresh();

        if ($routeTo) {
            $log->route = $routeTo;
        } else {
            $log->route = $logClass['route'];
        }
        return $log;
    }

    function getLogsByBriefId($id, $type)
    {
        $logClass = $this->quoteClasses($type);
        $log = $this->briefLogRepository->getLog($id);
        $log = $log->refresh();
        $log->route = $logClass['route'];

        return $log;
    }

    function delete($id, $type, $routeTo = "")
    {
        $logClass = $this->quoteClasses($type);
        $this->briefLogRepository->deleteLog($id);

        if ($routeTo) {
            $log['route'] = $routeTo;
        }


        return $log;
    }

    function quoteClasses($class)
    {
        $commentable = [
            'mobile_app_brief' => [
                'route' => 'app.brief-detail.detail',
                'class' => 'App\Models\MobileAppBrief'
            ],
            'smm_brief' => [
                'route' => 'smm.brief-detail.detail',
                'class' => 'App\Models\SmmBrief'
            ],
            'sem_brief' => [
                'route' => 'sem.brief-detail.detail',
                'class' => 'App\Models\SemBrief'
            ],
            'web_brief' => [
                'route' => 'web.brief-detail.detail',
                'class' => 'App\Models\WebBrief'
            ],
            'brief_link' => [
                'route' => 'brief.link.detail',
                'class' => 'App\Models\BriefLink'
            ],
            'brief' => [
                'route' => 'brief-detail.detail',
                'class' => 'App\Models\Brief'
            ],
            'video_brief' => [
                'route' => 'video.brief-detail.detail',
                'class' => 'App\Models\VideoBrief'
            ],
        ];

        return $commentable[$class];
    }
}
