<?php

namespace App\Services;

use App\Models\BriefActivity;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Jenssegers\Agent\Agent;

class BriefActivityService
{
    private $briefActivity, $apiService, $generateUniqueID;
   
    public function __construct()
    {
        $this->briefActivity = new BriefActivity();
        $this->apiService = new ApiService();
        $this->generateUniqueID = new GenerateUniqueID();
    }

  
    public function getBriefActivity($id, $brief_type)
    {
        try {
            return $this->briefActivity->with('loginHistory.user')->where('brief_id', $id)
            ->where('brief_type', $brief_type)
            ->latest()
            ->take(4)
            ->get();
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getAllBriefActivity($id, $brief_type)
    {
        try {
            return $this->briefActivity->with('loginHistory.user')->where('brief_id', $id)
            ->where('brief_type', $brief_type)
            ->get();
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function create($request, $brief_id, $brief_type, $activity, $activity_desc, $fingerprint)
    {
        try {
            $data = $this->apiService->fetchInfoAndUserAgent($request);
            $session_id= Session::getId();

            // Check if a record with this session_id already exists
            $existingRecord = $this->briefActivity->where('session_id', $session_id)->first();

            if ($existingRecord) {
                // If session_id exists, reuse the same custom_id
                $custom_id = $existingRecord->custom_id;
            } else {
                // If session_id does not exist, generate a new custom_id
                $prefix = 'vis';
                $length = 3;
                $custom_id = $this->generateUniqueID->create($prefix, $length);
            }

            return $this->briefActivity->create([
                'custom_id' => $custom_id,
                'session_id' => $session_id,
                'brief_id' => $brief_id,
                'brief_type' => $brief_type,
                'data' => response()->json($data)->content(),
                'fingerprint' => $fingerprint,
                'activity' => $activity,
                'activity_desc' => $activity_desc,
            ]);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function createViewActivity($request, $brief_id, $brief_type, $activity, $activity_desc, $fingerprint)
    {
        try {
            $data = $this->apiService->fetchInfoAndUserAgent($request);
            $session_id= Session::getId();

            // Check if a record with this session_id already exists
            $existingRecord = $this->briefActivity->where('session_id', $session_id)
            ->where('brief_type', $brief_type)
            ->where('activity_desc', $activity_desc)
            ->first();

            if ($existingRecord) {
                return $existingRecord->increment('no_of_visits');
            } else {

                $customIdExits = $this->briefActivity->where('session_id', $session_id)->first();

                if ($customIdExits) {
                    // If session_id exists, reuse the same custom_id
                    $custom_id = $customIdExits->custom_id;
                } else {
                    // If session_id does not exist, generate a new custom_id
                    $prefix = 'vis';
                    $length = 3;
                    $custom_id = $this->generateUniqueID->create($prefix, $length);
                }

                return $this->briefActivity->create([
                    'custom_id' => $custom_id,
                    'session_id' => $session_id,
                    'brief_id' => $brief_id,
                    'brief_type' => $brief_type,
                    'data' => response()->json($data)->content(),
                    'fingerprint' => $fingerprint,
                    'activity' => $activity,
                    'activity_desc' => $activity_desc,
                    'no_of_visits' => 1,
                ]);
            }
          
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    
}
