<?php 
namespace App\Services;

use App\Helper\FileHelper;
use App\Helper\NeutrinoHelper;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ApiService {
  public function fetchInfoAndUserAgent(Request $request) {
    try {
      $data['ipInfo'] = NeutrinoHelper::ipInfo($request->ip());
      $data['userAgent'] = NeutrinoHelper::userAgent($request->userAgent());

      if(!empty($data['ipInfo']) && (!empty($data['ipInfo']['latitude']) && !empty($data['ipInfo']['longitude']))) {
        $data['reverseGeocode'] = NeutrinoHelper::reverseGeocode($data['ipInfo']['longitude'], $data['ipInfo']['latitude']);
      }
      return $data;
    } catch (Exception $e) {
      Log::error($e->getMessage());
    }
  }

  public function fetchActivityAndCreateFile(Request $request, $token) {
    try {
      $data = $this->fetchInfoAndUserAgent($request);

      FileHelper::createOrUpdateFile($token, $data);

      return true;
    } catch (Exception $e) {
      Log::error($e->getMessage());
    }
  }
}