<?php 

namespace App\Repositories\PaymentGateway;

use App\Models\PaymentGateway;
use Exception;

class PaymentGatewayRepository implements PaymentGatewayInterface {
  private $paymentGateway;

  public function __construct(PaymentGateway $paymentGateway) {
    $this->paymentGateway = $paymentGateway;  
  }

  // Add payment gateway
  public function add(...$args) {
    $data['success'] = true;
    try {
      $gateway = $this->paymentGateway->create([
        'name' => $args['name'],
        'gateway' => $args['gateway'],
        'merchant_id' => $args['merchant_id'],
        'public_key' => $args['public_key'],
        'secret_key' => $args['secret_key'],
        'statement_descriptor' => $args['statement_descriptor'],
        'environment' => $args['environment'],
        'created_by' => $args['created_by'],
      ]);
      
      $data['data']['id'] = $gateway->id;
      
      return $data;
    } catch(Exception $ex) {
      $data['success'] = false;
      $data['message'] = $ex->getMessage();

      return $data;
    } 
  }

  // Update payment gateway
  public function update(...$args) {

  }

  // Detail of payment gateway
  public function gateway($id) {
    
  }

  // list of payment gateways
  public function list($select="") {
    $gateways = $this->paymentGateway;
    if($select!="") {
      $gateways = $gateways->select($select);
    }
    $gateways = $gateways->get();
    
    return $gateways;
  }
}