<?php 

namespace App\Repositories\Payment\TokenCustomer;

interface TokenCustomerInterface {
  // Create temporary customer 
  public function create($paymentLinkID, $temporaryCustomer);
  
  // Retreive temporary customer data 
  public function retrieve($temporaryCustomerID);
  
  // update temporary customer data 
  public function update($temporaryCustomerID, $data);
  
  // Soft delete temporary customer 
  public function delete($temporaryCustomerID);
  
  // Permanent delete temporary customer 
  public function permanentDelete($temporaryCustomerID);
}