<?php
namespace App\Services;

use Exception;
use Illuminate\Support\Facades\Log;
use GuzzleHttp\Exception\RequestException;

class PayPalErrorHandler
{
    public static function handle(RequestException $e)
    {
        $error = ['success' => false];

        if ($e->hasResponse()) {
            $errorResponse = json_decode($e->getResponse()->getBody()->getContents(), true);

            $errorName = $errorResponse['name'] ?? 'Unknown Error';
            $errorMessage = $errorResponse['message'] ?? 'Unknown Error Message';
            $debugId = $errorResponse['debug_id'] ?? 'No Debug ID';

            Log::error("PayPal API Error: $errorName - $errorMessage, Debug ID: $debugId");

            $error['message'] = $errorMessage;
            $error['debug_id'] = $debugId;
        } else {
            $error['message'] = $e->getMessage();
            Log::error("PayPal API Request Error: " . $e->getMessage());
        }

        return $error;
    }
}
