<?php

namespace App\Repositories\Customer;

use App\Models\User;

class CustomerRepository implements CustomerInterface
{
    private $customer;

    function __construct(User $customer)
    {
        $this->customer = $customer;
    }

    // Creating a new customer
    public function create($data)
    {
        $customer = $this->customer->create($data);
        $customer->assignRole('customer');
        $customer = $customer->refresh();

        return $customer;
    }

    //Find Customer via String
    public function findCustomers($keyword)
    {
        $customers = $this->customer->select('id', 'first_name', 'email', 'city', 'company', 'address', 'state', 'zipcode', 'country')
            ->where('first_name', 'like', $keyword . '%')
            ->orWhere('last_name', 'like', $keyword . '%')
            ->orWhere('email', 'like', $keyword . '%')
            ->get();

        return $customers;
    }

    // updating customer
    public function update($id, $request)
    {
        // $customer = $this->customer::whereId($id)->first();
        // $customer->update($data);
        // $customer = $customer->refresh();

        // return $customer;

        $customer = $this->customer->find($id);

        $fields = ['first_name', 'last_name', 'email', 'phone', 'city',  'company', 'address', 'state', 'zipcode', 'country', 'image', 'stripe_customer_id', 'stripe', 'stripe_pm_id', 'stripe_payment_method', 'created_by'];
        $updateData = [];

        foreach ($fields as $field) {
            if (!empty($request[$field])) {
                $updateData[$field] = $request[$field];
            }
        }

        if (!empty($updateData)) {
            $customer->update($updateData);
        }

        return $customer->id;
    }

    // fetching customer
    public function get($id)
    {
        $customer = $this->customer::find($id);

        return $customer;
    }

    // fetching customers list of customers
    public function list($conditions = [])
    {
        $customers = $this->customer::query();

        if (!empty($conditions)) {
            foreach ($conditions as $key => $value) {
                $customers->where($key, $value);
            }
        }

        return $customers->get();
    }

    // Creating a new customer
    public function delete($idOrIds)
    {
        if (is_array($idOrIds)) {
            $this->customer->destroy($idOrIds);
        } else {
            $customer = $this->customer::findOrFail($idOrIds);
            $customer->delete();
        }

        return true;
    }
}
