<?php

namespace App\Providers;

use App\Models\Team;
use App\Observers\TeamObserver;
use App\Services\CurrencyService;
use App\Services\SettingService;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // Country currencies
        $this->app->singleton(CurrencyService::class, function ($app) {
            return new CurrencyService();
        });

        // Setting Service
        $this->app->singleton(SettingService::class, function ($app) {
            return new SettingService();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Team::observe(TeamObserver::class);
    }
}
