<?php

namespace App\Models;

use App\Helper\EncodeHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;

class WebBrief extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'encoded_id',
        'brief_link_id',
        'location',
        'device',
        'email',
        'name',
        'phone',
        'business_name',
        'business_address',
        'business_phone',
        'business_email',
        'social_media_handles',
        'website',
        'web_hosting',
        'current_domain_address',
        'organization_operations',
        'website_purpose',
        'portray',
        'audience',
        'pages',
        'competitors',
        'website1_url',
        'website1_comments',
        'website2_url',
        'website2_comments',
        'website3_url',
        'website3_comments',
        'website_features',
        'maintenance_team',
        'website_content',
        'slogan',
        'have_logo',
        'redesign_logo',
        'website_fonts',
        'website_colors',
        'anything_else'
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($brief) {
            $brief->encoded_id = EncodeHelper::base64url_encode(md5($brief->id, true));
            $brief->save();
        });
    }

    public function scopeExcludeColumns($query, array $exclude)
    {
        // Get all columns from the table
        $columns = Schema::getColumnListing($this->getTable());

        // Filter out the excluded columns
        $selectedColumns = array_diff($columns, $exclude);

        // Return the query with the selected columns
        return $query->select($selectedColumns);
    }

    public function briefLogs()
    {
        return $this->morphMany(BriefLog::class, 'brief');
    }

    public function briefLink()
    {
        return $this->belongsTo(BriefLink::class, 'brief_link_id');
    }

    public function customer()
    {
        return $this->hasOne(User::class, 'id', 'customer_id');
    }

    public function briefData()
    {
        return $this->morphMany(BriefData::class, 'model');
    }
}
