<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class UserActivity extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'model_id',
        'model_type',
        'activity_type',
        'activity_desc'
    ];

    protected $casts = [
        'activity_desc' => 'array',
    ];

    public function user_activity_details()
    {
        return $this->hasMany(UserActivityDetail::class, 'user_activity_id');
    }


}
