<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'teams';

    protected $dates = ['deleted_at'];
    protected $fillable = ['id', 'name', 'description', 'target', 'color', 'created_by', 'updated_by', 'status', 'created_at', 'updated_at', 'deleted_at'];

    public static function statusCount($statuses)
    {
        $statusCounts = [];

        foreach ($statuses as $status) {
            switch ($status) {
                case 'all':
                    // Count products with both statuses 1 and 2
                    $statusCounts['available'] = self::where('status', 1)->count() + self::onlyTrashed()->count();
                    break;
                case 'archived':
                    // Count products with status 2
                    $statusCounts['archived'] = self::onlyTrashed()->count();
                    break;
                case 'available':
                    // Count products with status 1
                    $statusCounts['all'] = self::where('status', 1)->count();
                    break;
                default:
                    break;
            }
        }

        return $statusCounts;
    }
    public function teamLogs()
    {
        return $this->morphMany(PaymentLog::class, 'loggable');
    }
}
