<?php

namespace App\Models;

use App\Helper\EncodeHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;

class SemBrief extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'encoded_id',
        'brief_link_id',
        'customer_id',
        'device',
        'location',
        'email',
        'name',
        'designation',
        'phone',
        'business_name',
        'business_idea',
        'competitors',
        'product_strengths',
        'product_weaknesses',
        'actions',
        'campaign_purpose',
        'landing_pages',
        'u_s_p',
        'target_places',
        'budget',
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($brief) {
            $brief->encoded_id = EncodeHelper::base64url_encode(md5($brief->id, true));
            $brief->save();
        });
    }

    public function scopeExcludeColumns($query, array $exclude)
    {
        // Get all columns from the table
        $columns = Schema::getColumnListing($this->getTable());

        // Filter out the excluded columns
        $selectedColumns = array_diff($columns, $exclude);

        // Return the query with the selected columns
        return $query->select($selectedColumns);
    }

    public function briefLogs()
    {
        return $this->morphMany(BriefLog::class, 'brief');
    }

    public function briefLink()
    {
        return $this->belongsTo(BriefLink::class, 'brief_link_id');
    }

    public function customer()
    {
        return $this->hasOne(User::class, 'id', 'customer_id');
    }

    public function briefData()
    {
        return $this->morphMany(BriefData::class, 'model');
    }
}
