<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payments extends Model
{
  use HasFactory, HasRoles, SoftDeletes;

  protected $table = 'payments';
  protected $fillable =  ['customer_id','payment_link_id','price','discount','currency','ip','intent_id','intent','paymentMethod','charge','last_four','device','location','coupon_id','converted_amount','comment	text','gateway_message','status'];

  public function link()
  {
    return $this->hasOne(PaymentLink::class, 'id', 'payment_link_id');
  }

  public function category()
  {
    return $this->belongsTo(Category::class, 'category_id', 'id');
  }

  public function currency()
  {
    return $this->belongsTo(CountryCurrencies::class, 'currency', 'id');
  }

  public function customer()
  {
    return $this->belongsTo(User::class, 'customer_id', 'id');
  }

  public function payment_type()
  {
    return $this->belongsTo(PaymentLink::class, 'id', 'payment_type');
  }

  public function invoice()
  {
    return $this->belongsTo(Invoice::class, 'id', 'payment_id');
  }

  public function logs() {
    return $this->morphToMany(PaymentLog::class, 'loggable');
  }
}
