<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Helper\EncodeHelper;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;

class MobileAppBrief extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'email',
        'name',
        'phone',
        'business_name',
        'business_address',
        'business_phone',
        'business_email',
        'website_link',
        'web_hosting',
        'website_domain',
        'business_operations',
        'app_purpose',
        'app_look',
        'app_specification',
        'is_cms',
        'content_restriction',
        'users_accomplishment',
        'app_design',
        'publish_assistance',
        'app_pages_section',
        'app_reference',
        'app_users',
        'is_push_notification',
        'is_third_party_api',
        'app_tagline',
        'is_app_logo',
        'is_logo_redesign',
        'app_font_style',
        'app_colors',
        'comments',
        'brief_link_id',
        'customer_id',
        'location',
        'device',
        'encoded_id'
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($brief) {
            $brief->encoded_id = EncodeHelper::base64url_encode(md5($brief->id, true));
            $brief->save();
        });
    }

    public function scopeExcludeColumns($query, array $exclude)
    {
        // Get all columns from the table
        $columns = Schema::getColumnListing($this->getTable()); 

        // Filter out the excluded columns
        $selectedColumns = array_diff($columns, $exclude);

        // Return the query with the selected columns
        return $query->select($selectedColumns);
    }

    public function briefLink()
    {
        return $this->belongsTo(BriefLink::class, 'brief_link_id');
    }

    public function customer()
    {
        return $this->hasOne(User::class, 'id', 'customer_id');
    }

    public function briefData()
    {
        return $this->morphMany(BriefData::class, 'model');
    }
}
