<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
  use HasFactory, SoftDeletes;

  protected $fillable = ['id','invoice_no','custom_id','customer_id','payment_id','email_sent','data','created_by','status','comment'];

  public function customer()
  {
    return $this->belongsTo(User::class, 'customer_id', 'id');
  }

  public function payment()
  {
    return $this->belongsTo(Payment::class, 'payment_id', 'id');
  }

    public function paymentLink()
    {
        return $this->hasOneThrough(
            PaymentLink::class,
            Payment::class,
            'id', // Foreign key on the payments table
            'id', // Foreign key on the payment_links table
            'payment_id', // Local key on the invoices table
            'payment_link_id' // Local key on the payments table
        );
    }

    public function paymentLogs()
    {
        return $this->morphMany(PaymentLog::class, 'loggable');
    }
}
