<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model
{
    use HasFactory, SoftDeletes;

    protected $casts = [
        'date_to' => 'datetime',
        'date_from' => 'datetime',
    ];

    protected $fillable = [
        'data'
    ];

    public function couponLogs()
    {
        return $this->hasMany(CouponLog::class, 'coupon_id');
    }

    public function currencyCountry()
    {
        return $this->hasOne(CountryCurrencies::class, 'id', 'currency');
    }
}
