<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BriefLinkHistory extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'brief_link_histories';
    protected $fillable = ['id', 'brief_link_id', 'activity', 'ip_address', 'device', 'device_type', 'platform', 'country', 'browser', 'created_at', 'updated_at', 'deleted_at'];

    public function briefLink()
    {
        return $this->belongsTo(BriefLink::class, 'brief_link_id');
    }
}