<?php

namespace App\Jobs;

use App\Services\LogService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ApiLogJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $logService;
    private $activity, $type, $request, $response, $code, $loggableID, $createdBy, $event;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($activity, $type, $request, $response, $code, $loggableID, $createdBy, $event = 0, LogService $logService = null)
    {
        $this->activity = $activity;
        $this->type = $type;
        $this->request = $request;
        $this->response = $response;
        $this->code = $code;
        $this->loggableID = $loggableID;
        $this->createdBy = $createdBy;
        $this->event = $event;

        $this->logService = $logService ?: app(LogService::class);
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $this->logService->log('payment', [
            'activity' => $this->activity,
            'type' => $this->type,
            'request' => $this->request,
            'response' => $this->response,
            'code' => $this->code,
            'loggable_id' => $this->loggableID,
            'created_by' => $this->createdBy,
            'event' => $this->event,
        ]);
    }
}
