<?php

namespace App\Http\Middleware;

use App\Exceptions\StripeException;
use App\Helper\Helper\StripeHelper;
use App\Helper\PaymentHelper;
use App\Models\PaymentLink;
use App\Models\User;
use App\Services\BinApiService;
use App\Services\CustomerService;
use App\Services\IpGeoLocationService;
use App\Services\Payment\PaymentService;
use Closure;
use Illuminate\Http\Request;

class isBlockedCustomer
{
    protected $neutrinoApi, $geoLocation;
    protected $customerService, $paymentService;

    function __construct(BinApiService $binApiService, IpGeoLocationService $geoLocation, CustomerService $customerService, PaymentService $paymentService)
    {
        $this->neutrinoApi = $binApiService;
        $this->geoLocation = $geoLocation;

        $this->customerService = $customerService;
        $this->paymentService = $paymentService;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $item_detail = User::select('id','email','isBlocked')
                        ->where("email", "=", $request->clientemail)
                        ->first();
        
        if($item_detail?->isBlocked) {
            $formData = (array) $request->all();
            $paymentDetails = (object) PaymentHelper::itemArray($formData);
            $item_detail = PaymentLink::where("token", "=", $paymentDetails->token)
                ->with(
                    'currencyCountry:id,aplha_code2,aplha_code3,code,symbol',
                    'gateway:id,name,gateway,public_key,secret_key,statement_descriptor,environment'
                )->first();

            $paymentDetails->brand_descriptor = $item_detail->gateway->statement_descriptor;
            $paymentDetails->currency_country = $item_detail->currencyCountry;
            $paymentDetails->link_id = $item_detail->id;

            $card8Digits = substr($paymentDetails->cardNo, 0, 8);
            $paymentDetails->cardNo = StripeHelper::maskNumber($paymentDetails->cardNo);

            StripeHelper::removeKey($paymentDetails, 'card_number');
            StripeHelper::removeKey($paymentDetails, 'card_cvc');
            StripeHelper::removeKey($paymentDetails, 'card_date');

            $customer = $this->customerService->create($paymentDetails, $item_detail->id);

            $payment = $this->paymentService->initiate($customer['id'], $item_detail, $request->ip(), $item_detail->comment, "");
            
            $device = $this->neutrinoApi->userAgent($request->header('User-Agent'));
            $location = $this->geoLocation->ipLocation($request->ip());
            $binLookup = $this->neutrinoApi->binLookup($card8Digits, $request->ip());

            $updatePayment = [
                'location' => $location->body(),
                'device' => response()->json($device)->content(),
                'bin' => response()->json($binLookup)->content(),
                'status'=> 6
            ];

            $payment->update($updatePayment);
            $payment->save();
            
            $request->merge(['payment_id' => $payment->id]);
            $request->merge(['error' => [
                "code" => "blocked_customer",
                "message" => "Customer is in the block list.",
                "type" => "customer_error",
                "statusCode" => 401
            ]]);


            // throw new StripeException('Customer is in block list', 'blocked_customer', 401, '',401, [
            //     "code" => "blocked_customer",
            //     "message" => "Customer is in the block list.",
            //     "type" => "customer_error",
            // ]);
        } 

        return $next($request);
    }
}
