<?php

namespace App\Http\Middleware;

use App\Models\PaymentLink;
use App\Models\VisitedPaymentLink;
use App\Services\BinApiService;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;

class VerifyPaymentToken
{
    protected $neutrinoApi;

    function __construct(BinApiService $neutrinoApi) {
        $this->neutrinoApi = $neutrinoApi;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->route('token')) {
            $item_detail = PaymentLink::select('id','token','valid_till','payment_gateway','status')
                            ->where("token", "=", $request->route('token'))
                            ->with('gateway:id,name,gateway,public_key,secret_key,statement_descriptor,environment');

            if ($item_detail->exists()) {
                $item_detail = $item_detail->first();
                $finishTime = Carbon::now()->timestamp($item_detail->valid_till);
                $currentTime =  Carbon::now();
                
                $ip = $request->ip();
                $ipGeolocation = $this->neutrinoApi->ipInfo($ip);

                if(!empty($ipGeolocation['country-code']) && $ipGeolocation['country-code'] != 'PK') {
                    $ipGeolocation['userAgent'] = $this->neutrinoApi->userAgent($request->userAgent());
                    
                    VisitedPaymentLink::create([
                        'payment_link_id' => $item_detail->id,
                        'ip' => $ip,
                        'data'=> response()->json($ipGeolocation)->content()
                    ]);
                }

                if ($item_detail->status > 1) {
                    $data = array(
                        "heading" => "Sorry! Token is Expired.",
                        "message" => "Kindly chat with our sales team in this regard.",
                        "title" => "Sorry! Token is Expired | Token: " . $request->token,
                        "token" => $request->token,
                    );

                    return redirect()->route('payment.expired')->with(["failed_data" => $data]);
                } else {
                    //if(($finishTime > $currentTime) && ($item_detail->status!=2) && ($item_detail->status!=0)) {
                    if (($finishTime > $currentTime)) {
                        Session()->put('payment_gateway', $item_detail->gateway);
                        $response = $next($request);
                        return $response->header('Cache-Control', 'no-cache, no-store, max-age=0');
                    } else {
                        $data = array(
                            "heading" => "Sorry! Token is Expired.",
                            "message" => "Kindly chat with our sales team in this regard.",
                            "title" => "Sorry! Token is Expired | Token: " . $request->token,
                            "token" => $request->token,
                        );

                        return redirect()->route('payment.expired')->with(["failed_data" => $data]);
                    }
                }
            } else {
                $data = array(
                    "heading" => "Sorry! Token isn't valid.",
                    "message" => "Kindly chat with our sales team in this regard.",
                    "title" => "Sorry! Token isn't valid | Token: " . $request->token,
                    "token" => $request->token,
                );

                return redirect()->route('payment.expired')->with(["failed_data" => $data]);
            }
        } else {
            $data = array(
                "heading" => "Sorry! Token isn't exist.",
                "message" => "Kindly chat with our sales team in this regard.",
                "title" => "Sorry! Token isn't exist",
            );

            return redirect()->route('payment.expired')->with(["failed_data" => $data]);
        }
    }
}
