<?php

namespace App\Http\Middleware;

use App\Models\LoginHistory;
use App\Services\LoginHistoryService;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckSessionTimeout
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $userId = Auth::id();
            $sessionId = $request->session()->getId();
            
            $loginHistory = LoginHistory::where('user_id', $userId)
                ->where('session_id', $sessionId)
                ->first();

            if ($loginHistory) {
                $createdAt = Carbon::parse($loginHistory->created_at);
                $now = Carbon::now();
                $hoursDifference = $now->diffInHours($createdAt);

                // Check if the session has expired (more than 12 hours)
                if ($hoursDifference > 12) {
                    $createLogoutHistory = (new LoginHistoryService)->update($userId, $sessionId);
                    
                    Auth::logout();
                    $request->session()->invalidate();
                    $request->session()->regenerateToken();
                    return redirect()->route('login')->with('message', 'Your session has expired due to inactivity.');
                }
            }
        }


        return $next($request);
    }
}
