<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PaymentLink;
use App\Models\Quotes;
use App\Repositories\Quotes\QuotesInterface;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;

class QuotesController extends Controller
{
    private $quotes;

    function __construct(QuotesInterface $quotes)
    {
        $this->quotes = $quotes;    
    }

    public function getLog($id, $class="") {
        $data['success'] = true;
        
        try {
            $data['data'] = $this->quotes->get($id, $class);

            Redirect::route('');
        } catch(Exception $ex) {

        }
    }

    public function create(Request $request, $id) {
        try {
            $quote = $request->only(['comment', 'type']);
            $quote['commentable_id'] = $id;
            $quote['created_by'] = Auth::id();
            $quote = $this->quotes->quote($quote['type'], $quote);

            return Redirect::route($quote['route'], ['id' => $id]);
        } catch(Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function update(Request $request, $id, $quoteID) {
        try {
            $quote = $request->only(['comment', 'type']);

            if(isset($quote['comment']) && !empty($quote['comment'])) {
                $quote['commentable_id'] = $id;
                $quote['created_by'] = Auth::id();
                $quote = $this->quotes->update($quoteID, $quote);
            }

            return Redirect::route($quote['route'], ['id' => $id]);
        } catch(Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function delete(Request $request, $ID, $quoteID) {
        try {
            $quote = $request->only(['type']);
            $quote = $this->quotes->delete($quoteID, $quote['type']);

            return Redirect::route($quote['route'], ['id' => $ID]);
        } catch(Exception $ex) {
            dd($ex->getMessage());
        }
    }
}
