<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\PaymentGateway\PaymentGatewayInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PaymentGatewayController extends Controller
{
    private $paymentGateway;

    public function __construct(PaymentGatewayInterface $paymentGateway) {
        $this->paymentGateway = $paymentGateway;
    }

    public function store(Request $request) {
        $request = $request->only(['name', 'gateway', 'merchant_id', 'public_key', 'secret_key', 'statement_descriptor', 'environment']);
        
        $rules =  [
            'name' => 'required',
            'gateway' => 'required',
            'merchant_id' => 'nullable',
            'public_key' => 'required',
            'secret_key' => 'required',
            'statement_descriptor' => 'nullable',
            'environment' => 'required',
        ];
    
        $validator = Validator::make( $request, $rules);

        if($validator->validated()) {
            dd($this->paymentGateway->add($validator));
        } else {
            dd('chote');
        }
    }
}
