<?php
namespace App\Helper;

use Dompdf\Dompdf;
use Dompdf\Options;

class PDFHelper {
    public static function generatePDF($htmlContent, $page)
    {
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isPhpEnabled', true);
        $dompdf = new Dompdf($options);

        $dompdf->loadHtml($htmlContent);
        $dompdf->getOptions()->setDefaultFont('Helvetica');
        $dompdf->setPaper($page, 'portrait');
        $dompdf->render();

        return $dompdf->output();
    }
}