<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class UsersExport implements FromCollection, WithHeadings
{
    protected $customColumns, $dateRange, $rangeOption;

    public function __construct(array $customColumns, array $dateRange, string $rangeOption)
    {
        $this->customColumns = $customColumns;
        $this->dateRange = $dateRange;
        $this->rangeOption = $rangeOption;
    }


    public function collection()
    {
        $users = User::query();

        if($this->rangeOption !== 'all') {
            $users->whereBetween('created_at', [$this->dateRange['start'], $this->dateRange['end']]);
        } 
        // Retrieve users with related data
        return $users->get()->map(function ($user) {
            // $stripe = (!empty($user->stripe) ? json_decode($user->stripe, true) : []);
            $stripePM = (!empty($user->stripe_payment_method) ? json_decode($user->stripe_payment_method, true) : []);

            $data = [
                'id' => $user->id,
                'first_name' => $user->first_name,
                'last_name' => $user->last_name,
                'email' => $user->email,
                'phone' => $user->phone,
                'address' => $user->address,
                'company' => $user->company,
                'city' => $user->city,
                'state' => $user->state,
                'zipcode' => $user->zipcode,
                'country' => $user->country,
                'created_at' => $user->created_at,

                'customer_id' => $user->stripe_customer_id ?? '',
                'card' => $stripePM['card']['brand'] ?? '',
                'exp_month' => $stripePM['card']['exp_month'] ?? '',
                'exp_year' => $stripePM['card']['exp_year'] ?? '',
                'last4' => $stripePM['card']['last4'] ?? '',
            ];

            return (object)$data;
        });
    }

    public function headings(): array
    {
        
        // Conditionally add email column to headings
        if ($this->customColumns) {
            $headings = $this->customColumns;
        } else {
            $headings =['id', 'first_name', 'last_name', 'email', 'phone', 'address', 'company', 'city', 'state', 'zipcode', 'state', 'country', 'created_at'];

        }

        return $headings;
    }
}
