<?php

namespace App\Exceptions;

use Exception;

class StripeException extends Exception
{
    protected $errorType, $httpStatusCode, $requestId, $error;

    public function __construct($message, $errorType, $httpStatusCode, $requestId, $code = 0, $error, Exception $previous = null) {
        $this->errorType = $errorType;
        $this->httpStatusCode = $httpStatusCode;
        $this->requestId = $requestId;
        $this->error = $error;

        parent::__construct($message, $code, $previous);
    }

    public function getError()
    {
        return $this->error;
    }

    public function getErrorType()
    {
        return $this->errorType;
    }

    public function getHttpStatusCode()
    {
        return $this->httpStatusCode;
    }

    public function getRequestId()
    {
        return $this->requestId;
    }
}
