<?php

namespace App\Console;

use App\Jobs\ExpirePaymentLinks;
use App\Jobs\RefundListJob;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        $schedule->job(new ExpirePaymentLinks)->everySixHours();
        $schedule->job(new RefundListJob)->daily();
        
        $schedule->command('queue:work --stop-when-empty')
            ->everyMinute()
            ->withoutOverlapping();

        $schedule->command('notifications:delete-old')->everySixHours();

        $schedule->command('sessions:check')
            ->everyMinute()
            ->withoutOverlapping();

            $schedule->command('backup:database')
            ->dailyAt('03:00')
            ->timezone('America/New_York')
            ->withoutOverlapping(); //12:00 PM PST it will run
        
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
